/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiTexturedRect
extends Gui
implements IGuiComponent {
    GuiCustom parent;
    float scale = 1.0f;
    public int id;
    public int textureX;
    public int textureY;
    public int width;
    public int height;
    public int x;
    public int y;
    public int color;
    ResourceLocation texture;
    private final int[] offsets;
    String[] hoverText;
    IItemStack hoverStack;

    public static CustomGuiTexturedRect fromComponent(CustomGuiTexturedRectWrapper component) {
        CustomGuiTexturedRect rect = component.getTextureX() >= 0 && component.getTextureY() >= 0 ? new CustomGuiTexturedRect(component.getId(), component.getTexture(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getTextureX(), component.getTextureY()) : new CustomGuiTexturedRect(component.getId(), component.getTexture(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight());
        rect.scale = component.getScale();
        if (component.hasHoverText()) {
            rect.hoverText = component.getHoverText();
            rect.hoverStack = component.getHoverStack();
        }
        rect.color = component.getColor();
        return rect;
    }

    public CustomGuiTexturedRect(int id, String texture, int x, int y, int width, int height) {
        this(id, texture, x, y, width, height, 0, 0);
    }

    public CustomGuiTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        this.id = id;
        this.texture = new ResourceLocation(texture);
        this.x = GuiCustom.guiLeft + x;
        this.y = GuiCustom.guiTop + y;
        this.width = width;
        this.height = height;
        this.textureX = textureX;
        this.textureY = textureY;
        this.offsets = new int[]{0, 0};
        this.color = -1;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int[] getPosXY() {
        return new int[]{this.x, this.y};
    }

    @Override
    public void offSet(int offsetType, double[] windowSize) {
        switch (offsetType) {
            case 1: {
                this.offsets[0] = 0;
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            case 2: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = 0;
                break;
            }
            case 3: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            default: {
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        int x = this.offsets[0] == 0 ? this.x : this.offsets[0] - this.x - this.width;
        int y = this.offsets[1] == 0 ? this.y : this.offsets[1] - this.y - this.height;
        boolean hovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
        GlStateManager.func_179094_E();
        int pos = Math.min(this.id, 500);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)pos);
        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(this.texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)((float)y + (float)this.height * this.scale), (double)pos).func_187315_a((double)((float)this.textureX * 0.00390625f), (double)((float)(this.textureY + this.height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + (float)this.width * this.scale), (double)((float)y + (float)this.height * this.scale), (double)pos).func_187315_a((double)((float)(this.textureX + this.width) * 0.00390625f), (double)((float)(this.textureY + this.height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + (float)this.width * this.scale), (double)y, (double)pos).func_187315_a((double)((float)(this.textureX + this.width) * 0.00390625f), (double)((float)this.textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)pos).func_187315_a((double)((float)this.textureX * 0.00390625f), (double)((float)this.textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
        if (hovered) {
            if (this.hoverText != null && this.hoverText.length > 0) {
                this.parent.hoverText = this.hoverText;
            }
            if (this.hoverStack != null && !this.hoverStack.isEmpty()) {
                this.parent.hoverStack = this.hoverStack.getMCItemStack();
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public void setPosXY(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(this.id, this.texture.toString(), this.x, this.y, this.width, this.height, this.textureX, this.textureY);
        component.setHoverText(this.hoverText);
        component.setScale(this.scale);
        return component;
    }
}

